<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:svgu="http://www.ora.com/XSLTCookbook/ns/svg-utils"
  xmlns:test="http://www.ora.com/XSLTCookbook/ns/test"
  exclude-result-prefixes="svgu test">

<xsl:import href="svg-utils.xslt"/>

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" 
  doctype-public="-//W3C//DTD SVG 1.0/EN"
  doctype-system="http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd"/>

<test:xdata>0</test:xdata>
<test:xdata>5</test:xdata>
<test:xdata>10</test:xdata>
<test:xdata>15</test:xdata>
<test:xdata>20</test:xdata>
<test:xdata>25</test:xdata>
<test:xdata>30</test:xdata>
<test:xdata>35</test:xdata>
<test:xdata>40</test:xdata>
<test:xdata>45</test:xdata>
<test:xdata>50</test:xdata>
<test:xdata>55</test:xdata>
<test:xdata>60</test:xdata>
<test:xdata>65</test:xdata>
<test:xdata>70</test:xdata>
<test:xdata>75</test:xdata>
<test:xdata>80</test:xdata>
<test:xdata>85</test:xdata>
<test:xdata>90</test:xdata>
<test:xdata>95</test:xdata>
<test:xdata>100</test:xdata>
<test:xdata>105</test:xdata>
<test:xdata>110</test:xdata>
<test:xdata>115</test:xdata>
<test:xdata>120</test:xdata>
<test:xdata>125</test:xdata>
<test:xdata>130</test:xdata>
<test:xdata>135</test:xdata>
<test:xdata>140</test:xdata>
<test:xdata>145</test:xdata>
<test:xdata>150</test:xdata>
<test:xdata>155</test:xdata>
<test:xdata>160</test:xdata>
<test:xdata>165</test:xdata>
<test:xdata>170</test:xdata>
<test:xdata>175</test:xdata>
<test:xdata>180</test:xdata>
<test:xdata>185</test:xdata>
<test:xdata>190</test:xdata>
<test:xdata>195</test:xdata>
<test:xdata>200</test:xdata>
<test:xdata>205</test:xdata>
<test:xdata>210</test:xdata>
<test:xdata>215</test:xdata>
<test:xdata>220</test:xdata>
<test:xdata>225</test:xdata>
<test:xdata>230</test:xdata>
<test:xdata>235</test:xdata>
<test:xdata>240</test:xdata>
<test:xdata>245</test:xdata>
<test:xdata>250</test:xdata>
<test:xdata>255</test:xdata>
<test:xdata>260</test:xdata>
<test:xdata>265</test:xdata>
<test:xdata>270</test:xdata>
<test:xdata>275</test:xdata>
<test:xdata>280</test:xdata>
<test:xdata>285</test:xdata>
<test:xdata>290</test:xdata>
<test:xdata>295</test:xdata>
<test:xdata>300</test:xdata>
<test:xdata>305</test:xdata>
<test:xdata>310</test:xdata>
<test:xdata>315</test:xdata>
<test:xdata>320</test:xdata>
<test:xdata>325</test:xdata>
<test:xdata>330</test:xdata>
<test:xdata>335</test:xdata>
<test:xdata>340</test:xdata>
<test:xdata>345</test:xdata>
<test:xdata>350</test:xdata>
<test:xdata>355</test:xdata>
<test:xdata>360</test:xdata>
<test:ydata>0</test:ydata>
<test:ydata>0.087155743</test:ydata>
<test:ydata>0.173648178</test:ydata>
<test:ydata>0.258819045</test:ydata>
<test:ydata>0.342020143</test:ydata>
<test:ydata>0.422618262</test:ydata>
<test:ydata>0.5</test:ydata>
<test:ydata>0.573576436</test:ydata>
<test:ydata>0.64278761</test:ydata>
<test:ydata>0.707106781</test:ydata>
<test:ydata>0.766044443</test:ydata>
<test:ydata>0.819152044</test:ydata>
<test:ydata>0.866025404</test:ydata>
<test:ydata>0.906307787</test:ydata>
<test:ydata>0.939692621</test:ydata>
<test:ydata>0.965925826</test:ydata>
<test:ydata>0.984807753</test:ydata>
<test:ydata>0.996194698</test:ydata>
<test:ydata>1</test:ydata>
<test:ydata>0.996194698</test:ydata>
<test:ydata>0.984807753</test:ydata>
<test:ydata>0.965925826</test:ydata>
<test:ydata>0.939692621</test:ydata>
<test:ydata>0.906307787</test:ydata>
<test:ydata>0.866025404</test:ydata>
<test:ydata>0.819152044</test:ydata>
<test:ydata>0.766044443</test:ydata>
<test:ydata>0.707106781</test:ydata>
<test:ydata>0.64278761</test:ydata>
<test:ydata>0.573576436</test:ydata>
<test:ydata>0.5</test:ydata>
<test:ydata>0.422618262</test:ydata>
<test:ydata>0.342020143</test:ydata>
<test:ydata>0.258819045</test:ydata>
<test:ydata>0.173648178</test:ydata>
<test:ydata>0.087155743</test:ydata>
<test:ydata>0</test:ydata>
<test:ydata>-0.087155743</test:ydata>
<test:ydata>-0.173648178</test:ydata>
<test:ydata>-0.258819045</test:ydata>
<test:ydata>-0.342020143</test:ydata>
<test:ydata>-0.422618262</test:ydata>
<test:ydata>-0.5</test:ydata>
<test:ydata>-0.573576436</test:ydata>
<test:ydata>-0.64278761</test:ydata>
<test:ydata>-0.707106781</test:ydata>
<test:ydata>-0.766044443</test:ydata>
<test:ydata>-0.819152044</test:ydata>
<test:ydata>-0.866025404</test:ydata>
<test:ydata>-0.906307787</test:ydata>
<test:ydata>-0.939692621</test:ydata>
<test:ydata>-0.965925826</test:ydata>
<test:ydata>-0.984807753</test:ydata>
<test:ydata>-0.996194698</test:ydata>
<test:ydata>-1</test:ydata>
<test:ydata>-0.996194698</test:ydata>
<test:ydata>-0.984807753</test:ydata>
<test:ydata>-0.965925826</test:ydata>
<test:ydata>-0.939692621</test:ydata>
<test:ydata>-0.906307787</test:ydata>
<test:ydata>-0.866025404</test:ydata>
<test:ydata>-0.819152044</test:ydata>
<test:ydata>-0.766044443</test:ydata>
<test:ydata>-0.707106781</test:ydata>
<test:ydata>-0.64278761</test:ydata>
<test:ydata>-0.573576436</test:ydata>
<test:ydata>-0.5</test:ydata>
<test:ydata>-0.422618262</test:ydata>
<test:ydata>-0.342020143</test:ydata>
<test:ydata>-0.258819045</test:ydata>
<test:ydata>-0.173648178</test:ydata>
<test:ydata>-0.087155743</test:ydata>
<test:ydata>0</test:ydata>

<xsl:variable name="w" select="400"/>
<xsl:variable name="h" select="300"/>
<xsl:variable name="pwidth" select="$w * 0.8"/>
<xsl:variable name="pheight" select="$h * 0.8"/>
<xsl:variable name="offsetX" select="($w - $pwidth) div 2"/>
<xsl:variable name="offsetY" select="($h - $pheight) div 2"/>

<xsl:template match="/">

<svg width="{$w}" height="{$h}">

  <xsl:call-template name="svgu:xyPlot">
    <xsl:with-param name="dataX" select="document('')/*/test:xdata"/>  
    <xsl:with-param name="dataY" select="document('')/*/test:ydata"/>  
    <xsl:with-param name="offsetX" select="$offsetX"/>
    <xsl:with-param name="offsetY" select="$offsetY"/>
    <xsl:with-param name="width" select="$pwidth"/>
    <xsl:with-param name="height" select="$pheight"/>
    <!--
    <xsl:with-param name="minY" select="-1"/>
    <xsl:with-param name="maxY" select="1"/>
    -->
  </xsl:call-template>

  <xsl:call-template name="svgu:xAxis">
    <xsl:with-param name="min" select="0"/>
    <xsl:with-param name="max" select="360"/>
    <xsl:with-param name="offsetX" select="$offsetX"/>
    <xsl:with-param name="offsetY" select="-$pheight div 2 + $offsetY"/>
    <xsl:with-param name="width" select="$pwidth"/>
    <xsl:with-param name="height" select="$pheight"/>
    <xsl:with-param name="majorTicks" select="6"/>     <!-- Number of major axis divisions -->
    <xsl:with-param name="minorTicks" select="4"/>     <!-- Number of major axis divisions -->
  </xsl:call-template>

  <xsl:call-template name="svgu:yAxis">
    <xsl:with-param name="min" select="-1"/>
    <xsl:with-param name="max" select="1"/>
    <xsl:with-param name="offsetX" select="$offsetX"/>
    <xsl:with-param name="offsetY" select="$offsetY"/>
    <xsl:with-param name="width" select="$pwidth"/>
    <xsl:with-param name="height" select="$pheight"/>
  </xsl:call-template>


</svg>

</xsl:template>

</xsl:stylesheet>
